#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	[TestFixture]
	public class BOL_Lock : BaseTest 
	{
		System.Guid _lockedRecordGuid = System.Guid.NewGuid();
		DataTable _dtLocks;
		BOL.LockManager _lockControl;
		BOL.Lock _tstLock;
	    private bool _doOnlyOnce = true;
	    private int _lockFormId = -20;
	    private int _baseLockFormId = -20;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

            if (_doOnlyOnce)
            {
                this._lockControl = new LockManager(_lockFormId, _baseLockFormId, BOL.LockManager.DefaultLockInactivityTimeoutMin);
                this._lockControl.LockFunction = Common.LockFunctions.UnitTests;
            }

            this._tstLock = this._lockControl.LockRecord(this._lockedRecordGuid, Common.LockFunctions.UnitTests, false);

			this._dtLocks = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VbecsLock WHERE LockedRecordGuid = '" + this._lockedRecordGuid + "'", true);
		}

		[TearDown]
		protected void TearDown()
		{
		    this._lockControl.UnlockRecords();
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{			
			BOL.Lock tmpValue = new BOL.Lock(this._dtLocks.Rows[0]);

			Assert.IsNotNull(tmpValue);
            Assert.AreEqual(this._tstLock.LockedRecordGuid, tmpValue.LockedRecordGuid, "LockedRecordGuid");
            Assert.AreEqual(this._tstLock.LockedUseCase, tmpValue.LockedUseCase, "LockedUseCase");
		}

		[Test]
		public void Ctor_DataRow_Fail()
		{
			DataTable dt = new DataTable();
			BOL.Lock tmpValue = new BOL.Lock(dt.NewRow());
            Assert.True(tmpValue.SessionGuid == System.Guid.Empty, "SessionGuid is not Empty");
		}

		[Test]
		public void LockExists_Pass()
		{			
			Assert.AreEqual(true, this._tstLock.LockExists, "LockExists");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LockExists_Fail()
		{
		}

		[Test]
		public void LockConflictIndicator_Pass()
		{			
			Assert.AreEqual(false, this._tstLock.LockConflictIndicator(12345), "LockConflictIndicator");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LockConflictIndicator_Fail()
		{
		}

		[Test]
        public void LockedRecordGuid_Pass()
		{
            Assert.AreEqual(this._lockedRecordGuid, this._tstLock.LockedRecordGuid, "LockedRecordGuid");
		}

		[Test]
		public void UserNTLoginId_Pass()
		{			
			Assert.AreEqual(Common.LogonUser.LogonUserName, this._tstLock.UserNTLoginId, "UserNTLoginId");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void UserNTLoginId_Fail()
		{
		}

		[Test]
		public void UserName_Pass()
		{			
			Assert.AreEqual(new BOL.VbecsUser(Common.LogonUser.LogonUserName).UserName,this._tstLock.UserName, "UserName");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void UserName_Fail()
		{
		}

		[Test]
		public void LockCreatedTime_Pass()
		{			
			Assert.AreEqual(this._tstLock.LockCreatedTime, this._tstLock.LockCreatedTime, "LockCreatedTime");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LockCreatedTime_Fail()
		{
		}

		[Test]
        public void LockFunctionId_Pass()
		{
            Assert.AreEqual(Common.LockFunctions.UnitTests, this._tstLock.LockFunctionId, "LockFunctionId");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
        public void LockFunctionId_Fail()
		{
		}

		[Test]
		public void SessionGuid_Pass()
		{			
			System.Guid tmpGuid = this._tstLock.SessionGuid;
			
			Assert.AreEqual(tmpGuid, this._tstLock.SessionGuid, "SessionGuid");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void SessionGuid_Fail()
		{
		}

	}
}
#endif

